using System;
using System.Collections;
using System.Collections.Generic;
using Unity.VisualScripting.FullSerializer;
using UnityEngine;
using UnityEngine.Events;
using UnityEngine.InputSystem.iOS;
using static UnityEngine.GraphicsBuffer;

public delegate void QRewardsCallBack(bool worked);

public class QActionController : MonoBehaviour
{
    // Start is called before the first frame update
    private QStateController qController;
    private EnemyController enemyController;
    private Health healthScript;
    private Stamina staminaScript;

    [SerializeField] private List<UnityEvent<QRewardsCallBack>> castAttacks;


    [Header("Rewards")]
    /*[SerializeField] private float staminaHighUse;
    [SerializeField] private float staminaMediumUse;
    [SerializeField] private float staminaLowUse;

    [SerializeField] private float healthHighUse;
    [SerializeField] private float healthMediumUse;
    [SerializeField] private float healthLowUse;

    [SerializeField] private float successLightAttack;
    [SerializeField] private float successHeavyAttack;

    [SerializeField] private float successDodgeAttack;
    [SerializeField] private float successParryAttack;*/
    public Dictionary<string, float> rewards = new Dictionary<string, float>();
    public Dictionary<string, float> cost = new Dictionary<string, float>();

    [SerializeField] private List<DictionaryTranslator> rewardsList;
    [SerializeField] private List<DictionaryTranslator> costList;


    private float hpDif;
    private float staminaDif;

    //Simulated values
    private float sHp = 0;
    private float sStamina = 0;
    private int sStance = 0;
    public string lastState;
    private void Awake()
    {
        if(rewardsList != null)
        {
            for(int i = 0; i < rewardsList.Count; i++)
            {
                rewards.Add(rewardsList[i].type, rewardsList[i].reward);
            }
        }

        if (costList != null)
        {
            for (int i = 0; i < costList.Count; i++)
            {
                cost.Add(costList[i].type, costList[i].reward);
            }
        }
    }
    private void Start()
    {
        qController = GetComponent<QStateController>();
        enemyController = GetComponent<EnemyController>();
        healthScript = GetComponent<Health>();
        staminaScript= GetComponent<Stamina>();

    }

    public string Simulator(string state, int action, int iteration)
    {
        if(iteration == 0) { 
            sHp= healthScript.GetHealth(); 
            sStamina = staminaScript.GetStamina();
            sStance = enemyController.GetStance();
        }

        ExecuteAction((QLActions)action, true);
        return qController.CalculateNewState(sHp, sStamina, (state[2] == 'D'), (state[3] == 'A'));
    }
    
    public void ExecuteAction(QLActions action, bool simulated)
    {
        switch (action)
        {
            case QLActions.Wait:
                break;
            case QLActions.Light_Attack:
                //Invoque LightAttack;
                if(simulated) 
                {
                    sStamina -= cost["lightAttack"];
                }
                else
                {
                    staminaScript.TakeStamina(cost["lightAttack"]);
                    castAttacks[1].Invoke(enemyController.CheckSuccess);
                }
                Debug.Log("LA");
                break;
            case QLActions.Heavy_Attack:
                //Invoque HeavyAttack;
                if (simulated)
                {
                    sStamina -= cost["heavyAttack"];
                }
                else
                {
                    staminaScript.TakeStamina(cost["heavyAttack"]);
                    castAttacks[2].Invoke(enemyController.CheckSuccess);

                }
                Debug.Log("HA");
                break;
            case QLActions.Dodge:
                //Invoque Dodge;
                if (simulated)
                {
                    sStamina -= cost["dodge"];
                }
                else
                {
                    staminaScript.TakeStamina(cost["dodge"]);
                    healthScript.invunerable = true;
                    enemyController.CheckSuccess(true);
                }
                Debug.Log("DODGE");
                break;
            case QLActions.Parry:
                //Invoque Dodge;
                if (simulated)
                {
                    sHp -= cost["parryHPReduction"];
                    sStamina -= cost["parryStaminaCost"];
                }
                else
                {
                    enemyController.CheckSuccess(true);
                }
                Debug.Log("DODGE");
                break;
            case QLActions.ChangeStance_D:
                //Invoque Defense stance;
                if (simulated)
                {
                    sStance = enemyController.target.stance;
                }
                else
                {
                    //Change my stance to the same as target
                    //Add on the invoke the change Stance
                    enemyController.ChangeStance(true);
                    enemyController.CheckSuccess(true);
                }
                Debug.Log("SD");
                break;
            case QLActions.ChangeStance_A:
                //Invoque Defense stance;
                if (simulated)
                {
                    if (sStance == enemyController.target.stance)
                    {
                        if (sStance >= 2) sStance = 0;
                        else sStance++;
                    }
                }
                else
                {
                    //Change my stance to one different from targets
                    enemyController.ChangeStance(false);
                    enemyController.CheckSuccess(true);
                }
                Debug.Log("SA");
                break;
            default:
                Debug.LogError("Somehow an non existing QLAction was invoqued");
                break;
        }
    }

    [Serializable]
    private struct DictionaryTranslator
    {
        public string type; 
        public float reward;
    }
}
