using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using UnityEngine;
using UnityEngine.Experimental.GlobalIllumination;

public class QL_Table
{
    private Dictionary<string, List<QAction_Reward>> q_table = new Dictionary<string, List<QAction_Reward>>();

    public void PopulateTable(string json)
    {
        if (File.Exists(json))
        {
            SerializableDictionary t = JsonUtility.FromJson<SerializableDictionary>(File.ReadAllText(json));
            foreach (Q_Value_Holder q_value in t.q_values)
            {
                if (!q_table.ContainsKey(q_value.status)) q_table.Add(q_value.status, q_value.value);
            }
        }
    }

    public void ExportTable(string path) 
    {
        /*q_table.Add("HHDA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.Parry, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("HHDO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.Parry, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("HHAO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("HHAA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        //
        q_table.Add("HMDA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.Parry, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("HMDO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.Parry, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("HMAO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("HMAA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        //
        q_table.Add("HLDA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("HLDO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("HLAO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("HLAA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        //

        q_table.Add("MHDA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.Parry, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("MHDO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.Parry, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("MHAO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("MHAA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        //
        q_table.Add("MMDA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.Parry, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("MMDO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.Parry, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("MMAO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("MMAA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        //
        q_table.Add("MLDA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("MLDO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("MLAO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("MLAA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        //


        q_table.Add("LHDA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.Parry, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("LHDO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.Parry, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("LHAO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("LHAA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        //
        q_table.Add("LMDA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.Parry, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("LMDO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.Parry, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("LMAO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("LMAA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.Light_Attack, 1), new QAction_Reward(QLActions.Heavy_Attack, 1), new QAction_Reward(QLActions.Dodge, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });

        //missing
        q_table.Add("LLDA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1)});
        q_table.Add("LLDO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("LLAO", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });
        q_table.Add("LLAA", new List<QAction_Reward>() { new QAction_Reward(QLActions.Wait, 1), new QAction_Reward(QLActions.ChangeStance_D, 1), new QAction_Reward(QLActions.ChangeStance_A, 1) });*/
        SerializableDictionary t = new SerializableDictionary(q_table) ;
        string t2 = JsonUtility.ToJson(t, true);

        using (StreamWriter sw = new StreamWriter(path))
        {
            sw.Write(t2);
        }
    }

    public float GetReward(string state, int action)
    {
        List<QAction_Reward> t = q_table[state];
        foreach (QAction_Reward q_value in t) {
            if ((int)q_value.action == action)
                return q_value.reward;
        }
        Debug.LogWarning("Action: " + action + " does not exist in state " + state);
        //Null value for float, since the max reward is well below this
        return -81655;
    }
    
    public QAction_Reward[] GetAvailableOptions(string state) 
    {
        if (q_table.ContainsKey(state))
        {
            return q_table[state].ToArray();
        }
        return null;
    }
    public void UpdateQTable(string state, int action, float reward)
    {
        if (q_table.ContainsKey(state))
        {
            for(int i = 0; i < q_table[state].Count; i++)
            {
                if ((int)q_table[state][i].action == action)
                {
                    q_table[state][i] = new QAction_Reward((QLActions)action, reward);
                }
            }
        }
        else Debug.LogError("Unexisting state: " + state);
    }
}
[Serializable]
public struct QAction_Reward
{
    public QLActions action;
    public float reward;
    public QAction_Reward(QLActions action, float reward)
    {
        this.action = action; 
        this.reward = reward;
    }
}
[Serializable]
public struct Q_Value_Holder
{
    public string status;
    public List<QAction_Reward> value;

    public Q_Value_Holder(string status, List<QAction_Reward> value)
    {
        this.status = status;
        this.value = value;
    }
}
[Serializable]
public class SerializableDictionary {
    public List<Q_Value_Holder> q_values= new List<Q_Value_Holder>();

    public SerializableDictionary(Dictionary<string, List<QAction_Reward>> q_table)
    {
        foreach(string status in q_table.Keys)
        {
            q_values.Add(new Q_Value_Holder(status, q_table[status]));
        }
    }
}