/*
 * Decompiled with CFR 0.152.
 */
package net.dragon81655.dragoncommands.events;

import com.mojang.brigadier.CommandDispatcher;
import net.dragon81655.dragoncommands.capabilities.player.PlayerEconomy;
import net.dragon81655.dragoncommands.capabilities.player.PlayerEconomyProvider;
import net.dragon81655.dragoncommands.claims.ClaimRegister;
import net.dragon81655.dragoncommands.commands.AddMoneyCommand;
import net.dragon81655.dragoncommands.commands.CheckMoneyCommand;
import net.dragon81655.dragoncommands.commands.ClaimEnemyCommand;
import net.dragon81655.dragoncommands.commands.ClaimInfoCommand;
import net.dragon81655.dragoncommands.commands.ClaimRenameCommand;
import net.dragon81655.dragoncommands.commands.ClaimSetOwnerCommand;
import net.dragon81655.dragoncommands.commands.ClaimSetUnbreakableCommand;
import net.dragon81655.dragoncommands.commands.ClaimTrustCommand;
import net.dragon81655.dragoncommands.commands.ClaimUntrustCommand;
import net.dragon81655.dragoncommands.commands.RemoveMoneyCommand;
import net.dragon81655.dragoncommands.commands.SetMoneyCommand;
import net.dragon81655.dragoncommands.commands.SetSpawnCommand;
import net.dragon81655.dragoncommands.commands.SpawnCommand;
import net.dragon81655.dragoncommands.commands.TransferMoneyCommand;
import net.dragon81655.dragoncommands.networking.ModMessages;
import net.dragon81655.dragoncommands.networking.packet.ClaimDataS2CPacket;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.command.ConfigCommand;

@Mod.EventBusSubscriber(modid="dragoncommands", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEvents {
    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        System.out.println("Registering events");
        new SpawnCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new ClaimTrustCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new ClaimRenameCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new ClaimUntrustCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new ClaimInfoCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new SetSpawnCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new TransferMoneyCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new SetMoneyCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new CheckMoneyCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new ClaimSetUnbreakableCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new ClaimSetOwnerCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new ClaimEnemyCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new RemoveMoneyCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new AddMoneyCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onBreakEvent(BlockEvent.BreakEvent event) {
        boolean b = ClaimRegister.CheckIfIsClaimOwner(event.getPlayer(), event.getPos());
        if (b) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        boolean b;
        if (event.getEntity() instanceof Player && (b = ClaimRegister.CheckIfIsClaimOwner((Player)event.getEntity(), event.getPos()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ModMessages.sendToPlayer(new ClaimDataS2CPacket(ClaimRegister.claimData), (ServerPlayer)event.getPlayer());
    }

    @SubscribeEvent
    public static void onAttachCapabilityPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerEconomyProvider.PLAYER_ECONOMY).isPresent()) {
            event.addCapability(new ResourceLocation("dragoncommands", "properties"), (ICapabilityProvider)new PlayerEconomyProvider());
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof Player) {
            Player p = (Player)event.getEntityLiving();
            p.getCapability(PlayerEconomyProvider.PLAYER_ECONOMY).ifPresent(b -> PlayerEconomyProvider.balances.put((Object)p.m_5446_().getString(), (Object)b.balance()));
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            Player p = event.getPlayer();
            p.getCapability(PlayerEconomyProvider.PLAYER_ECONOMY).ifPresent(b -> b.setBalance((Integer)PlayerEconomyProvider.balances.get((Object)p.m_5446_().getString())));
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PlayerEconomy.class);
    }
}

