/*
 * Decompiled with CFR 0.152.
 */
package net.dragon81655.dragoncommands.networking.packet;

import java.util.function.Supplier;
import net.dragon81655.dragoncommands.capabilities.player.PlayerEconomy;
import net.dragon81655.dragoncommands.capabilities.player.PlayerEconomyProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class BankRequestC2SPacket {
    private int value;
    private int numberOfCoins;

    public BankRequestC2SPacket(int value, int numberOfCoins) {
        this.value = value;
        this.numberOfCoins = numberOfCoins;
    }

    public BankRequestC2SPacket(FriendlyByteBuf buf) {
        this.value = buf.readInt();
        this.numberOfCoins = buf.readInt();
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            boolean canExecute = false;
            int numberNeeded = this.numberOfCoins;
            block0: while (numberNeeded > 0) {
                if (player.m_150109_().m_36062_() == -1) {
                    for (ItemStack i : player.m_150109_().f_35974_) {
                        if (!i.m_41720_().getRegistryName().toString().equals("dragoncommands:coin" + this.value) || (numberNeeded -= 64 - i.m_41613_()) > 0) continue;
                        canExecute = true;
                        break block0;
                    }
                    break;
                }
                if ((numberNeeded -= 64) > 0) continue;
                canExecute = true;
            }
            if (canExecute) {
                player.getCapability(PlayerEconomyProvider.PLAYER_ECONOMY).ifPresent(arg_0 -> this.lambda$handle$0((Player)player, arg_0));
            } else {
                player.m_6352_((Component)new TextComponent("You don't have enough space in the inventory to receive the coins"), player.m_142081_());
            }
        });
        context.setPacketHandled(true);
        return true;
    }

    public static BankRequestC2SPacket decode(FriendlyByteBuf friendlyByteBuf) {
        return new BankRequestC2SPacket(friendlyByteBuf);
    }

    public static void encode(BankRequestC2SPacket value, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeInt(value.value);
        friendlyByteBuf.writeInt(value.numberOfCoins);
    }

    private /* synthetic */ void lambda$handle$0(Player player, PlayerEconomy c) {
        if (c.remove(this.value * this.numberOfCoins)) {
            Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dragoncommands:coin" + this.value));
            ItemStack item = new ItemStack((ItemLike)i, this.numberOfCoins);
            player.m_36356_(item);
            player.m_6352_((Component)new TextComponent(this.numberOfCoins + " coins of " + this.value + " were added to your inventory!"), player.m_142081_());
        } else {
            player.m_6352_((Component)new TextComponent("You don't have enough funds!"), player.m_142081_());
        }
    }
}

